#!/usr/bin/perl

# Copyright 2023 Aleisha Amohia <aleisha@catalyst.net.nz>
#
# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Koha is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Koha; if not, see <http://www.gnu.org/licenses>.

use Modern::Perl;
use CGI qw ( -utf8 );
use C4::Auth qw( get_template_and_user );
use C4::Context;
use C4::Output qw( output_html_with_http_headers );
use Koha::Patrons;
use Koha::Token;

my $query = CGI->new();

my ( $template, $borrowernumber, $cookie ) = get_template_and_user(
    {
        template_name => 'opac-alert-subscriptions.tt',
        query         => $query,
        type          => 'opac',
    }
);

my $patron = Koha::Patrons->find($borrowernumber);

$template->param(
    alertsview => 1,
    patron     => $patron,
    referer    => 'patron',
);

my $new_session_id = $query->cookie('CGISESSID');
$template->param(
    csrf_token => Koha::Token->new->generate_csrf(
        {
            session_id => $new_session_id,
        }
    ),
);

output_html_with_http_headers $query, $cookie, $template->output, undef, { force_no_caching => 1 };
